# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24828);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-11");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-11
(Amarok: User-assisted remote execution of arbitrary code)


    The Magnatune downloader doesn\'t quote the "m_currentAlbumFileName"
    parameter while calling the "unzip" shell command.
  
Impact

    A compromised or malicious Magnatune server can remotely execute
    arbitrary shell code with the rights of the user running Amarok on a
    client that have previously registered for buying music.
  
Workaround

    Do not use the Magnatune component of Amarok.
  
References:
    http://secunia.com/advisories/24159


Solution: 
    All Amarok users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-sound/amarok-1.4.5-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-11] Amarok: User-assisted remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Amarok: User-assisted remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-sound/amarok", unaffected: make_list("ge 1.4.5-r1"), vulnerable: make_list("lt 1.4.5-r1")
)) { security_warning(0); exit(0); }
