# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-20.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24869);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-20");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-20
(LSAT: Insecure temporary file creation)


    LSAT insecurely writes in /tmp with a predictable filename.
  
Impact

    A local attacker could create symbolic links in the temporary files
    directory, pointing to a valid file somewhere on the filesystem. When
    the LSAT script is executed, this would result in the file being
    overwritten with the rights of the user running the software, which
    could be the root user.
  
Workaround

    There is no known workaround at this time.
  

Solution: 
    Since LSAT is not actively maintained anymore, this package has been
    masked. All LSAT users are advised to unmerge it.
    # emerge --ask --unmerge "app-admin/lsat"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-20] LSAT: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'LSAT: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-admin/lsat", unaffected: make_list(), vulnerable: make_list("le 0.9.2")
)) { security_warning(0); exit(0); }
