# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-27.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24932);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-27");
 script_cve_id("CVE-2007-1560");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-27
(Squid: Denial of Service)


    Squid incorrectly handles TRACE requests that contain a "Max-Forwards"
    header field with value "0" in the clientProcessRequest() function.
  
Impact

    A remote attacker can send specially crafted TRACE HTTP requests that
    will terminate the child process. A quickly repeated attack will lead
    to a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1560


Solution: 
    All Squid users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-proxy/squid-2.6.12"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-27] Squid: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Squid: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-proxy/squid", unaffected: make_list("ge 2.6.12"), vulnerable: make_list("lt 2.6.12")
)) { security_warning(0); exit(0); }
