# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24934);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-01");
 script_cve_id("CVE-2007-1561", "CVE-2007-1594");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-01
(Asterisk: Two SIP Denial of Service vulnerabilities)


    The Madynes research team at INRIA has discovered that Asterisk
    contains a null pointer dereferencing error in the SIP channel when
    handling INVITE messages. Furthermore qwerty1979 discovered that
    Asterisk 1.2.x fails to properly handle SIP responses with return code
    0.
  
Impact

    A remote attacker could cause an Asterisk server listening for SIP
    messages to crash by sending a specially crafted SIP message or
    answering with a 0 return code.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1561
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1594


Solution: 
    All Asterisk users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose net-misc/asterisk
    Note: Asterisk 1.0.x is no longer supported upstream so users should
    consider upgrading to Asterisk 1.2.x.
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-01] Asterisk: Two SIP Denial of Service vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Asterisk: Two SIP Denial of Service vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-misc/asterisk", unaffected: make_list("ge 1.2.14-r2", "rge 1.0.12-r2"), vulnerable: make_list("lt 1.2.14-r2")
)) { security_warning(0); exit(0); }
