# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-14.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25059);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-14");
 script_cve_id("CVE-2007-2028");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-14
(FreeRADIUS: Denial of Service)


    The Coverity Scan project has discovered a memory leak within the
    handling of certain malformed Diameter format values inside an EAP-TTLS
    tunnel.
  
Impact

    A remote attacker could send a large amount of specially crafted
    packets to a FreeRADIUS server using EAP-TTLS authentication and
    exhaust all memory, possibly resulting in a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2028


Solution: 
    All FreeRADIUS users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-dialup/freeradius-1.1.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-14] FreeRADIUS: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'FreeRADIUS: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-dialup/freeradius", unaffected: make_list("ge 1.1.6"), vulnerable: make_list("lt 1.1.6")
)) { security_warning(0); exit(0); }
