# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-16.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25104);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-16");
 script_cve_id("CVE-2007-2057");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-16
(Aircrack-ng: Remote execution of arbitrary code)


    Jonathan So reported that the airodump-ng module does not correctly
    check the size of 802.11 authentication packets before copying them
    into a buffer.
  
Impact

    A remote attacker could trigger a stack-based buffer overflow by
    sending a specially crafted 802.11 authentication packet to a user
    running airodump-ng with the -w (--write) option. This could lead to
    the remote execution of arbitrary code with the permissions of the user
    running airodump-ng, which is typically the root user.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2057


Solution: 
    All Aircrack-ng users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-wireless/aircrack-ng-0.7-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-16] Aircrack-ng: Remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Aircrack-ng: Remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-wireless/aircrack-ng", unaffected: make_list("ge 0.7-r2"), vulnerable: make_list("lt 0.7-r2")
)) { security_hole(0); exit(0); }
