# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-18.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25106);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200704-18");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-18
(Courier-IMAP: Remote execution of arbitrary code)


    CJ Kucera has discovered that some Courier-IMAP scripts don\'t properly
    handle the XMAILDIR variable, allowing for shell command injection.
  
Impact

    A remote attacker could send specially crafted login credentials to a
    Courier-IMAP server instance, possibly leading to remote code execution
    with root privileges.
  
Workaround

    There is no known workaround at this time.
  

Solution: 
    All Courier-IMAP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-mail/courier-imap-4.0.6-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-18] Courier-IMAP: Remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Courier-IMAP: Remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-mail/courier-imap", unaffected: make_list("ge 4.0.6-r2", "lt 4.0.0"), vulnerable: make_list("lt 4.0.6-r2")
)) { security_hole(0); exit(0); }
