# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200704-23.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25111);
 script_version("$Revision: 1.2 $");
 script_xref(name: "GLSA", value: "200704-23");
 script_cve_id("CVE-2007-1217");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200704-23
(capi4k-utils: Buffer overflow)


    The bufprint() function in capi4k-utils fails to properly check
    boundaries of data coming from CAPI packets.
  
Impact

    A local attacker could possibly escalate privileges or cause a Denial
    of Service by sending a crafted CAPI packet.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=2007-1217


Solution: 
    All capi4k-utils users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-dialup/capi4k-utils-20050718-r3"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200704-23] capi4k-utils: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'capi4k-utils: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-dialup/capi4k-utils", unaffected: make_list("ge 20050718-r3"), vulnerable: make_list("lt 20050718-r3")
)) { security_hole(0); exit(0); }
