# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25184);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-07");
 script_cve_id("CVE-2007-1869", "CVE-2007-1870");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-07
(Lighttpd: Two Denials of Service)


    Robert Jakabosky discovered an infinite loop triggered by a connection
    abort when Lighttpd processes carriage return and line feed sequences.
    Marcus Rueckert discovered a NULL pointer dereference when a server
    running Lighttpd tries to access a file with a mtime of 0.
  
Impact

    A remote attacker could upload a specially crafted file to the server
    or send a specially crafted request and then abort the connection,
    possibly resulting in a crash or a Denial of Service by CPU
    consumption.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1869
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1870


Solution: 
    All Lighttpd users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-servers/lighttpd-1.4.14"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-07] Lighttpd: Two Denials of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Lighttpd: Two Denials of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-servers/lighttpd", unaffected: make_list("ge 1.4.14"), vulnerable: make_list("lt 1.4.14")
)) { security_warning(0); exit(0); }
