# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25236);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-15");
 script_cve_id("CVE-2007-2444", "CVE-2007-2446", "CVE-2007-2447");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-15
(Samba: Multiple vulnerabilities)


    Samba contains a logical error in the smbd daemon when translating
    local SID to user names (CVE-2007-2444). Furthermore, Samba contains
    several bugs when parsing NDR encoded RPC parameters (CVE-2007-2446).
    Lastly, Samba fails to properly sanitize remote procedure input
    provided via Microsoft Remote Procedure Calls (CVE-2007-2447).
  
Impact

    A remote attacker could exploit these vulnerabilities to gain root
    privileges via various vectors.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2444
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2446
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2447


Solution: 
    All Samba users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-fs/samba-3.0.24-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-15] Samba: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Samba: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-fs/samba", unaffected: make_list("ge 3.0.24-r2"), vulnerable: make_list("lt 3.0.24-r2")
)) { security_hole(0); exit(0); }
