# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-17.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25288);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200705-17");
 script_cve_id("CVE-2007-1359");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-17
(Apache mod_security: Rule bypass)


    Stefan Esser discovered that mod_security processes NULL characters as
    terminators in POST requests using the
    application/x-www-form-urlencoded encoding type, while other parsers
    used in web applications do not.
  
Impact

    A remote attacker could send a specially crafted POST request, possibly
    bypassing the module ruleset and leading to the execution of arbitrary
    code in the scope of the web server with the rights of the user running
    the web server.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1359


Solution: 
    All mod_security users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-www/mod_security-2.1.1"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-17] Apache mod_security: Rule bypass");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Apache mod_security: Rule bypass');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-www/mod_security", unaffected: make_list("ge 2.1.1"), vulnerable: make_list("lt 2.1.1")
)) { security_warning(0); exit(0); }
