# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200705-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25384);
 script_version("$Revision: 1.2 $");
 script_xref(name: "GLSA", value: "200705-25");
 script_cve_id("CVE-2007-2799");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200705-25
(file: Integer overflow)


    Colin Percival from FreeBSD reported that the previous fix for the
    file_printf() buffer overflow introduced a new integer overflow.
  
Impact

    A remote attacker could entice a user to run the file program on an
    overly large file (more than 1Gb) that would trigger an integer
    overflow on 32-bit systems, possibly leading to the execution of
    arbitrary code with the rights of the user running file.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2799


Solution: 
    Since file is a system package, all Gentoo users should upgrade to the
    latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=sys-apps/file-4.21"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200705-25] file: Integer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'file: Integer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-apps/file", arch: "x86 ppc hppa", unaffected: make_list("ge 4.21"), vulnerable: make_list("lt 4.21")
)) { security_hole(0); exit(0); }
