# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25438);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-01");
 script_cve_id("CVE-2007-2645");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-01
(libexif: Integer overflow vulnerability)


    Victor Stinner reported an integer overflow in the
    exif_data_load_data_entry() function from file exif-data.c while
    handling Exif data.
  
Impact

    An attacker could entice a user to process a file with specially
    crafted Exif extensions with an application making use of libexif,
    which will trigger the integer overflow and potentially execute
    arbitrary code or crash the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2645


Solution: 
    All libexif users should upgrade to the latest version. Please note
    that users upgrading from "<=media-libs/libexif-0.6.13" should also run
    revdep-rebuild after their upgrade.
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/libexif-0.6.15"
    # revdep-rebuild --library=/usr/lib/libexif.so
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-01] libexif: Integer overflow vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'libexif: Integer overflow vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/libexif", unaffected: make_list("ge 0.6.15"), vulnerable: make_list("lt 0.6.15")
)) { security_warning(0); exit(0); }
