# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25452);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-02");
 script_cve_id("CVE-2007-1002");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-02
(Evolution: User-assisted execution of arbitrary code)


    Ulf Hrnhammar from Secunia Research has discovered a format string
    error in the write_html() function in the file
    calendar/gui/e-cal-component-memo-preview.c.
  
Impact

    A remote attacker could entice a user to open a specially crafted
    shared memo, possibly resulting in the execution of arbitrary code with
    the privileges of the user running Evolution.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1002


Solution: 
    All Evolution users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/evolution-2.8.3-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-02] Evolution: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Evolution: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "mail-client/evolution", unaffected: make_list("ge 2.8.3-r2"), vulnerable: make_list("lt 2.8.3-r2")
)) { security_warning(0); exit(0); }
