# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25474);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-04");
 script_cve_id("CVE-2007-2829", "CVE-2007-2830", "CVE-2007-2831");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-04
(MadWifi: Multiple vulnerabilities)


    Md Sohail Ahmad from AirTight Networks has discovered a divison by zero
    in the ath_beacon_config() function (CVE-2007-2830). The vendor has
    corrected an input validation error in the
    ieee80211_ioctl_getwmmparams() and ieee80211_ioctl_getwmmparams()
    functions(CVE-207-2831), and an input sanitization error when parsing
    nested 802.3 Ethernet frame lengths (CVE-2007-2829).
  
Impact

    An attacker could send specially crafted packets to a vulnerable host
    to exploit one of these vulnerabilities, possibly resulting in the
    execution of arbitrary code with root privileges, or a Denial of
    Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2829
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2830
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2831


Solution: 
    All MadWifi users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-wireless/madwifi-ng-0.9.3.1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-04] MadWifi: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MadWifi: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-wireless/madwifi-ng", unaffected: make_list("ge 0.9.3.1"), vulnerable: make_list("lt 0.9.3.1")
)) { security_hole(0); exit(0); }
