# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25562);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-07");
 script_cve_id("CVE-2007-1575", "CVE-2007-1576", "CVE-2007-1638", "CVE-2007-1639");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-07
(PHProjekt: Multiple vulnerabilities)


    Alexios Fakos from n.runs AG has discovered multiple vulnerabilities in
    PHProjekt, including the execution of arbitrary SQL commands using
    unknown vectors (CVE-2007-1575), the execution of arbitrary PHP code
    using an unrestricted file upload (CVE-2007-1639), cross-site request
    forgeries using different modules (CVE-2007-1638), and a cross-site
    scripting attack using unkown vectors (CVE-2007-1576).
  
Impact

    An authenticated user could elevate their privileges by exploiting the
    vulnerabilities described above. Note that the magic_quotes_gpc PHP
    configuration setting must be set to "off" to exploit these
    vulnerabilities.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1575
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1576
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1638
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1639


Solution: 
    All PHProjekt users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/phprojekt-5.2.1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-07] PHProjekt: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PHProjekt: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/phprojekt", unaffected: make_list("ge 5.2.1"), vulnerable: make_list("lt 5.2.1")
)) { security_hole(0); exit(0); }
