# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-08.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25593);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-08");
 script_cve_id("CVE-2007-2435", "CVE-2007-2788", "CVE-2007-2789");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-08
(emul-linux-x86-java: Multiple vulnerabilities)


    Chris Evans of the Google Security Team has discovered an integer
    overflow in the ICC parser, and another vulnerability in the BMP
    parser. An unspecified vulnerability involving an "incorrect use of
    system classes" was reported by the Fujitsu security team.
  
Impact

    A remote attacker could entice a user to open a specially crafted
    image, possibly resulting in the execution of arbitrary code with the
    privileges of the user running Emul-linux-x86-java. They also could
    entice a user to open a specially crafted BMP image, resulting in a
    Denial of Service. Note that these vulnerabilities may also be
    triggered by a tool processing image files automatically.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2435
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2788
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2789


Solution: 
    All Emul-linux-x86-java users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emulation/emul-linux-x86-java-1.5.0.11"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-08] emul-linux-x86-java: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'emul-linux-x86-java: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-emulation/emul-linux-x86-java", unaffected: make_list("ge 1.5.0.11"), vulnerable: make_list("lt 1.5.0.11")
)) { security_warning(0); exit(0); }
