# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200706-09.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25594);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200706-09");
 script_cve_id("CVE-2006-4168");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200706-09
(libexif: Buffer overflow)


    iDefense Labs have discovered that the exif_data_load_data_entry()
    function in libexif/exif-data.c improperly handles integer data while
    working with an image with many EXIF components, allowing an integer
    overflow possibly leading to a heap-based buffer overflow.
  
Impact

    An attacker could entice a user of an application making use of a
    vulnerable version of libexif to load a specially crafted image file,
    possibly resulting in a crash of the application or the execution of
    arbitrary code with the rights of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4168


Solution: 
    All libexif users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/libexif-0.6.16"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200706-09] libexif: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'libexif: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/libexif", unaffected: make_list("ge 0.6.16"), vulnerable: make_list("lt 0.6.16")
)) { security_warning(0); exit(0); }
