# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200707-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25660);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200707-02");
 script_cve_id("CVE-2007-0245", "CVE-2007-2754");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200707-02
(OpenOffice.org: Two buffer overflows)


    John Heasman of NGSSoftware has discovered a heap-based buffer overflow
    when parsing the "prdata" tag in RTF files where the first token is
    smaller than the second one (CVE-2007-0245). Additionally, the
    OpenOffice binary program is shipped with a version of FreeType that
    contains an integer signedness error in the n_points variable in file
    truetype/ttgload.c, which was covered by GLSA 200705-22
    (CVE-2007-2754).
  
Impact

    A remote attacker could entice a user to open a specially crafted
    document, possibly leading to execution of arbitrary code with the
    rights of the user running OpenOffice.org.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0245
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2754
    http://www.gentoo.org/security/en/glsa/glsa-200705-22.xml


Solution: 
    All OpenOffice.org users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-office/openoffice-2.2.1"
    All OpenOffice.org binary users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-office/openoffice-bin-2.2.1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200707-02] OpenOffice.org: Two buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenOffice.org: Two buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-office/openoffice-bin", unaffected: make_list("ge 2.2.1"), vulnerable: make_list("lt 2.2.1")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "app-office/openoffice", unaffected: make_list("ge 2.2.1"), vulnerable: make_list("lt 2.2.1")
)) { security_warning(0); exit(0); }
