# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200707-14.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25810);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200707-14");
 script_cve_id("CVE-2007-3798");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200707-14
(tcpdump: Integer overflow)


    mu-b from Digital Labs discovered that the return value of a snprintf()
    call is not properly checked before being used. This could lead to an
    integer overflow.
  
Impact

    A remote attacker could send specially crafted BGP packets on a network
    being monitored with tcpdump, possibly resulting in the execution of
    arbitrary code with the privileges of the user running tcpdump, which
    is usually root.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3798


Solution: 
    All tcpdump users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-analyzer/tcpdump-3.9.5-r3"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200707-14] tcpdump: Integer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'tcpdump: Integer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-analyzer/tcpdump", unaffected: make_list("ge 3.9.5-r3"), vulnerable: make_list("lt 3.9.5-r3")
)) { security_hole(0); exit(0); }
