# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(25916);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-10");
 script_cve_id("CVE-2007-3780", "CVE-2007-3781");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-10
(MySQL: Denial of Service and information leakage)


    Dormando reported a vulnerability within the handling of password
    packets in the connection protocol (CVE-2007-3780). Andrei Elkin also
    found that the "CREATE TABLE LIKE" command didn\'t require SELECT
    privileges on the source table (CVE-2007-3781).
  
Impact

    A remote unauthenticated attacker could use the first vulnerability to
    make the server crash. The second vulnerability can be used by
    authenticated users to obtain information on tables they are not
    normally able to access.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3780
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3781


Solution: 
    All MySQL users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-db/mysql-5.0.44"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-10] MySQL: Denial of Service and information leakage");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MySQL: Denial of Service and information leakage');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/mysql", unaffected: make_list("ge 5.0.44"), vulnerable: make_list("lt 5.0.44")
)) { security_warning(0); exit(0); }
