# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200708-17.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26040);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200708-17");
 script_cve_id("CVE-2007-3142", "CVE-2007-3819", "CVE-2007-3929", "CVE-2007-4367");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200708-17
(Opera: Multiple vulnerabilities)


    An error known as "a virtual function call on an invalid pointer" has
    been discovered in the JavaScript engine (CVE-2007-4367). Furthermore,
    iDefense Labs reported that an already-freed pointer may be still used
    under unspecified circumstances in the BitTorrent support
    (CVE-2007-3929). At last, minor other errors have been discovered,
    relative to memory read protection (Opera Advisory 861) and URI
    displays (CVE-2007-3142, CVE-2007-3819).
  
Impact

    A remote attacker could trigger the BitTorrent vulnerability by
    enticing a user into starting a malicious BitTorrent download, and
    execute arbitrary code through unspecified vectors. Additionally, a
    specially crafted JavaScript may trigger the "virtual function"
    vulnerability. The JavaScript engine can also access previously freed
    but uncleaned memory. Finally, a user can be fooled with a too long
    HTTP server name that does not fit the dialog box, or a URI containing
    whitespaces.
  
Workaround

    There is no known workaround at this time for all these
    vulnerabilities.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3142
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3819
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3929
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4367
    http://www.opera.com/support/search/view/861/


Solution: 
    All Opera users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/opera-9.23"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200708-17] Opera: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Opera: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/opera", unaffected: make_list("ge 9.23"), vulnerable: make_list("lt 9.23")
)) { security_warning(0); exit(0); }
