# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-05.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26095);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-05");
 script_cve_id("CVE-2007-3410");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-05
(RealPlayer: Buffer overflow)


    A stack-based buffer overflow vulnerability has been reported in the
    SmilTimeValue::parseWallClockValue() function in smlprstime.cpp when
    handling HH:mm:ss.f type time formats.
  
Impact

    By enticing a user to open a specially crafted SMIL (Synchronized
    Multimedia Integration Language) file, an attacker could be able to
    execute arbitrary code with the privileges of the user running the
    application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3410


Solution: 
    All RealPlayer users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-video/realplayer-10.0.9"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-05] RealPlayer: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'RealPlayer: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-video/realplayer", unaffected: make_list("ge 10.0.9"), vulnerable: make_list("lt 10.0.9")
)) { security_warning(0); exit(0); }
