# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26097);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-07");
 script_cve_id("CVE-2007-2807");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-07
(Eggdrop: Buffer overflow)


    Bow Sineath discovered a boundary error in the file
    mod/server.mod/servrmsg.c when processing overly long private messages
    sent by an IRC server.
  
Impact

    A remote attacker could entice an Eggdrop user to connect the bot to a
    malicious server, possibly resulting in the execution of arbitrary code
    on the host running Eggdrop.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2807


Solution: 
    All Eggdrop users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-irc/eggdrop-1.6.18-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-07] Eggdrop: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Eggdrop: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-irc/eggdrop", unaffected: make_list("ge 1.6.18-r2"), vulnerable: make_list("lt 1.6.18-r2")
)) { security_warning(0); exit(0); }
