# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-13.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26103);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-13");
 script_cve_id("CVE-2007-4091");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-13
(rsync: Two buffer overflows)


    Sebastian Krahmer from the SUSE Security Team discovered two off-by-one
    errors in the function "f_name()" in file sender.c when processing
    overly long directory names.
  
Impact

    A remote attacker could entice a user to synchronize a repository
    containing specially crafted directories, leading to the execution of
    arbitrary code with the privileges of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4091


Solution: 
    All rsync users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-misc/rsync-2.6.9-r3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-13] rsync: Two buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'rsync: Two buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-misc/rsync", unaffected: make_list("ge 2.6.9-r3"), vulnerable: make_list("lt 2.6.9-r3")
)) { security_warning(0); exit(0); }
