# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-14.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26104);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-14");
 script_cve_id("CVE-2007-4510", "CVE-2007-4560");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-14
(ClamAV: Multiple vulnerabilities)


    Nikolaos Rangos discovered a vulnerability in ClamAV which exists
    because the recipient address extracted from email messages is not
    properly sanitized before being used in a call to "popen()" when
    executing sendmail (CVE-2007-4560). Also, NULL-pointer dereference
    errors exist within the "cli_scanrtf()" function in libclamav/rtf.c and
    Stefanos Stamatis discovered a NULL-pointer dereference vulnerability
    within the "cli_html_normalise()" function in libclamav/htmlnorm.c
    (CVE-2007-4510).
  
Impact

    The unsanitized recipient address can be exploited to execute arbitrary
    code with the privileges of the clamav-milter process by sending an
    email with a specially crafted recipient address to the affected
    system. Also, the NULL-pointer dereference errors can be exploited to
    crash ClamAV. Successful exploitation of the latter vulnerability
    requires that clamav-milter is started with the "black hole" mode
    activated, which is not enabled by default.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4510
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4560


Solution: 
    All ClamAV users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-antivirus/clamav-0.91.2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-14] ClamAV: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'ClamAV: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-antivirus/clamav", unaffected: make_list("ge 0.91.2"), vulnerable: make_list("lt 0.91.2")
)) { security_hole(0); exit(0); }
