# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200709-16.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26214);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200709-16");
 script_cve_id("CVE-2007-4727");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200709-16
(Lighttpd: Buffer overflow)


    Mattias Bengtsson and Philip Olausson have discovered a buffer overflow
    vulnerability in the function fcgi_env_add() in the file mod_fastcgi.c
    when processing overly long HTTP headers.
  
Impact

    A remote attacker could send a specially crafted request to the
    vulnerable Lighttpd server, resulting in the remote execution of
    arbitrary code with privileges of the user running the web server. Note
    that mod_fastcgi is disabled in Gentoo\'s default configuration.
  
Workaround

    Edit the file /etc/lighttpd/lighttpd.conf and comment the following
    line: "include mod_fastcgi.conf"
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4727


Solution: 
    All Lighttpd users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-servers/lighttpd-1.4.18"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200709-16] Lighttpd: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Lighttpd: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-servers/lighttpd", unaffected: make_list("ge 1.4.18"), vulnerable: make_list("lt 1.4.18")
)) { security_hole(0); exit(0); }
