# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26942);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-02");
 script_cve_id("CVE-2007-1883", "CVE-2007-1887", "CVE-2007-1900", "CVE-2007-2756", "CVE-2007-2872", "CVE-2007-3007", "CVE-2007-3378", "CVE-2007-3806", "CVE-2007-3996", "CVE-2007-3997", "CVE-2007-3998", "CVE-2007-4652", "CVE-2007-4657", "CVE-2007-4658", "CVE-2007-4659", "CVE-2007-4660", "CVE-2007-4661", "CVE-2007-4662", "CVE-2007-4663", "CVE-2007-4670", "CVE-2007-4727", "CVE-2007-4782", "CVE-2007-4783", "CVE-2007-4784", "CVE-2007-4825", "CVE-2007-4840", "CVE-2007-4887");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-02
(PHP: Multiple vulnerabilities)

Impact

    Remote attackers might be able to exploit these issues in PHP
    applications making use of the affected functions, potentially
    resulting in the execution of arbitrary code, Denial of Service,
    execution of scripted contents in the context of the affected site,
    security bypass or information leak.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1883
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1887
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1900
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2756
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2872
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3007
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3378
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3806
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3996
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3997
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3998
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4652
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4657
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4658
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4659
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4660
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4661
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4662
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4663
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4670
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4727
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4782
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4783
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4784
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4825
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4840
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4887
    http://www.gentoo.org/security/en/glsa/glsa-200705-19.xml


Solution: 
    All PHP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/php-5.2.4_p20070914-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-02] PHP: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PHP: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/php", unaffected: make_list("ge 5.2.4_p20070914-r2"), vulnerable: make_list("lt 5.2.4_p20070914-r2")
)) { security_hole(0); exit(0); }
