# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-05.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(26945);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-05");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-05
(QGit: Insecure temporary file creation)


    Raphael Marichez discovered that the DataLoader::doStart() method
    creates temporary files in an insecure manner and executes them.
  
Impact

    A local attacker could perform a symlink attack, possibly overwriting
    files or executing arbitrary code with the rights of the user running
    QGit.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://nvd.nist.gov/nvd.cfm?cvename=CVE-2007-4631


Solution: 
    All QGit users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-util/qgit-1.5.7"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-05] QGit: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'QGit: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-util/qgit", unaffected: make_list("ge 1.5.7"), vulnerable: make_list("lt 1.5.7")
)) { security_warning(0); exit(0); }
