# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27557);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-25");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-25
(MLDonkey: Privilege escalation)


    The Gentoo MLDonkey ebuild adds a user to the system named "p2p" so
    that the MLDonkey service can run under a user with low privileges.
    This user is created with a valid login shell and no password.
  
Impact

    A remote attacker could log into a vulnerable system as the p2p user.
    This would require an installed login service that permitted empty
    passwords, such as SSH configured with the "PermitEmptyPasswords yes"
    option, a local login console, or a telnet server.
  
Workaround

    See Resolution.
  

Solution: 
    Change the p2p user\'s shell to disallow login. For example, as root run
    the following command:
    # usermod -s /bin/false p2p
    NOTE: updating to the current MLDonkey ebuild will not remove this
    vulnerability, it must be fixed manually. The updated ebuild is to
    prevent this problem from occurring in the future.
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-25] MLDonkey: Privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MLDonkey: Privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-p2p/mldonkey", unaffected: make_list("ge 2.9.0-r3"), vulnerable: make_list("lt 2.9.0-r3")
)) { security_hole(0); exit(0); }
