# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-26.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27558);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-26");
 script_cve_id("CVE-2007-5208");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-26
(HPLIP: Privilege escalation)


    Kees Cook from the Ubuntu Security team discovered that the hpssd
    daemon does not correctly validate user supplied data before passing it
    to a "popen3()" call.
  
Impact

    A local attacker may be able to exploit this vulnerability by sending a
    specially crafted request to the hpssd daemon to execute arbitrary
    commands with the privileges of the user running hpssd, usually root.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5208


Solution: 
    All HPLIP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "net-print/hplip"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-26] HPLIP: Privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'HPLIP: Privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-print/hplip", unaffected: make_list("rge 1.7.4a-r2", "ge 2.7.9-r1"), vulnerable: make_list("lt 2.7.9-r1")
)) { security_hole(0); exit(0); }
