# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-28.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27579);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-28");
 script_cve_id("CVE-2007-4137");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-28
(Qt: Buffer overflow)


    Dirk Mueller from the KDE development team discovered a boundary error
    in file qutfcodec.cpp when processing Unicode strings.
  
Impact

    A remote attacker could send a specially crafted Unicode string to a
    vulnerable Qt application, possibly resulting in the remote execution
    of arbitrary code with the privileges of the user running the
    application. Note that the boundary error is present but reported to be
    not exploitable in 4.x series.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4137


Solution: 
    All Qt 3.x users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/qt-3.3.8-r4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-28] Qt: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Qt: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-libs/qt", unaffected: make_list("ge 3.3.8-r4"), vulnerable: make_list("lt 3.3.8-r4")
)) { security_warning(0); exit(0); }
