# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200710-29.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27580);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200710-29");
 script_cve_id("CVE-2007-2958");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200710-29
(Sylpheed, Claws Mail: User-assisted remote execution of arbitrary code)


    Ulf Harnhammar from Secunia Research discovered a format string error
    in the inc_put_error() function in file src/inc.c.
  
Impact

    A remote attacker could entice a user to connect to a malicious POP
    server sending specially crafted replies, possibly resulting in the
    execution of arbitrary code with the privileges of the user running the
    application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-2958


Solution: 
    All Sylpheed users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/sylpheed-2.4.5"
    All Claws Mail users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/claws-mail-3.0.0"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200710-29] Sylpheed, Claws Mail: User-assisted remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Sylpheed, Claws Mail: User-assisted remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "mail-client/sylpheed", unaffected: make_list("ge 2.4.5"), vulnerable: make_list("lt 2.4.5")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "mail-client/claws-mail", unaffected: make_list("ge 3.0.0"), vulnerable: make_list("lt 3.0.0")
)) { security_warning(0); exit(0); }
