# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27611);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-01");
 script_cve_id("CVE-2007-3961", "CVE-2007-3962");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-01
(gFTP: Multiple vulnerabilities)


    Kalle Olavi Niemitalo discovered two boundary errors in fsplib code
    included in gFTP when processing overly long directory or file names.
  
Impact

    A remote attacker could trigger these vulnerabilities by enticing a
    user to download a file with a specially crafted directory or file
    name, possibly resulting in the execution of arbitrary code
    (CVE-2007-3962) or a Denial of Service (CVE-2007-3961).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3961
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3962


Solution: 
    All gFTP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-ftp/gftp-2.0.18-r6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-01] gFTP: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'gFTP: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-ftp/gftp", unaffected: make_list("ge 2.0.18-r6"), vulnerable: make_list("lt 2.0.18-r6")
)) { security_warning(0); exit(0); }
