# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-03.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27613);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-03");
 script_cve_id("CVE-2007-4650");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-03
(Gallery: Multiple vulnerabilities)


    Merrick Manalastas and Nicklous Roberts have discovered multiple
    vulnerabilities in the WebDAV and Reupload modules.
  
Impact

    A remote attacker could exploit these vulnerabilities to bypass
    security restrictions and rename, replace and change properties of
    items, or edit item data using WebDAV.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4650


Solution: 
    All Gallery users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/gallery-2.2.3"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-03] Gallery: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Gallery: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/gallery", unaffected: make_list("ge 2.2.3"), vulnerable: make_list("lt 2.2.3")
)) { security_warning(0); exit(0); }
