# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27815);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-04");
 script_cve_id("CVE-2007-3257");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-04
(Evolution: User-assisted remote execution of arbitrary code)


    The imap_rescan() function of the file camel-imap-folder.c does not
    properly sanitize the "SEQUENCE" response sent by an IMAP server before
    being used to index arrays.
  
Impact

    A malicious or compromised IMAP server could trigger the vulnerability
    and execute arbitrary code with the permissions of the user running
    Evolution.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200707-03.xml
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3257


Solution: 
    Note that this GLSA addresses the same issue as GLSA 200707-03, but for
    the 1.10 branch of Evolution Data Server.
    All Evolution users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=gnome-extra/evolution-data-server-1.10.3.1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-04] Evolution: User-assisted remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Evolution: User-assisted remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "gnome-extra/evolution-data-server", unaffected: make_list("ge 1.10.3.1"), vulnerable: make_list("lt 1.10.3.1")
)) { security_warning(0); exit(0); }
