# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27846);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-11");
 script_cve_id("CVE-2007-5198", "CVE-2007-5623");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-11
(Nagios Plugins: Two buffer overflows)


    fabiodds reported a boundary checking error in the "check_snmp" plugin
    when processing SNMP "GET" replies that could lead to a stack-based
    buffer overflow (CVE-2007-5623). Nobuhiro Ban reported a boundary
    checking error in the redir() function of the "check_http" plugin when
    processing HTTP "Location:" header information which might lead to a
    buffer overflow (CVE-2007-5198).
  
Impact

    A remote attacker could exploit these vulnerabilities to execute
    arbitrary code with the privileges of the user running Nagios or cause
    a Denial of Service by (1) sending a specially crafted SNMP "GET" reply
    to the Nagios daemon or (2) sending an overly long string in the
    "Location:" header of an HTTP reply. Note that to exploit (2), the
    malicious or compromised web server has to be configured in Nagios and
    the "-f" (follow) option has to be enabled.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5198
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5623


Solution: 
    All users of the Nagios Plugins should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-analyzer/nagios-plugins-1.4.10-r1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-11] Nagios Plugins: Two buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Nagios Plugins: Two buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-analyzer/nagios-plugins", unaffected: make_list("ge 1.4.10-r1"), vulnerable: make_list("lt 1.4.10-r1")
)) { security_hole(0); exit(0); }
