# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-18.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28218);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-18");
 script_cve_id("CVE-2007-4476");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-18
(Cpio: Buffer overflow)


    A buffer overflow vulnerability in the safer_name_suffix() function in
    GNU cpio has been discovered.
  
Impact

    A remote attacker could entice a user to open a specially crafted
    archive file resulting in a stack-based buffer overflow, possibly
    crashing the application. It is disputed whether the execution of
    arbitrary code is possible.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4476


Solution: 
    All GNU cpio users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/cpio-2.9-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-18] Cpio: Buffer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Cpio: Buffer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-arch/cpio", unaffected: make_list("ge 2.9-r1"), vulnerable: make_list("lt 2.9-r1")
)) { security_warning(0); exit(0); }
