# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28219);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-19");
 script_cve_id("CVE-2007-5423", "CVE-2007-5682");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-19
(TikiWiki: Multiple vulnerabilities)


    Stefan Esser reported that a previous vulnerability (CVE-2007-5423,
    GLSA 200710-21) was not properly fixed in TikiWiki 1.9.8.1
    (CVE-2007-5682). The TikiWiki development team also added several
    checks to avoid file inclusion.
  
Impact

    A remote attacker could exploit these vulnerabilities to inject
    arbitrary code with the privileges of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200710-21.xml
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5423
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5682


Solution: 
    All TikiWiki users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/tikiwiki-1.9.8.3"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-19] TikiWiki: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'TikiWiki: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/tikiwiki", unaffected: make_list("ge 1.9.8.3"), vulnerable: make_list("lt 1.9.8.3")
)) { security_hole(0); exit(0); }
