# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-20.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28220);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-20");
 script_cve_id("CVE-2007-5933");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-20
(Pioneers: Denial of Service)


    Bas Wijnen discovered that the Pioneers server may free sessions
    objects while they are still in use, resulting in access to invalid
    memory zones.
  
Impact

    A remote attacker could send specially crafted data to the vulnerable
    server, resulting in a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5933


Solution: 
    All Pioneers users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=games-board/pioneers-0.11.3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-20] Pioneers: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Pioneers: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "games-board/pioneers", unaffected: make_list("ge 0.11.3"), vulnerable: make_list("lt 0.11.3")
)) { security_warning(0); exit(0); }
