# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-23.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28262);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-23");
 script_cve_id("CVE-2004-0813", "CVE-2006-3619", "CVE-2006-4146", "CVE-2006-4600", "CVE-2007-0061", "CVE-2007-0062", "CVE-2007-0063", "CVE-2007-1716", "CVE-2007-4496", "CVE-2007-4497", "CVE-2007-5617");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-23
(VMware Workstation and Player: Multiple vulnerabilities)


    Multiple vulnerabilities have been discovered in several VMware
    products. Neel Mehta and Ryan Smith (IBM ISS X-Force) discovered that
    the DHCP server contains an integer overflow vulnerability
    (CVE-2007-0062), an integer underflow vulnerability (CVE-2007-0063) and
    another error when handling malformed packets (CVE-2007-0061), leading
    to stack-based buffer overflows or stack corruption. Rafal Wojtczvk
    (McAfee) discovered two unspecified errors that allow authenticated
    users with administrative or login privileges on a guest operating
    system to corrupt memory or cause a Denial of Service (CVE-2007-4496,
    CVE-2007-4497). Another unspecified vulnerability related to untrusted
    virtual machine images was discovered (CVE-2007-5617).
    VMware products also shipped code copies of software with several
    vulnerabilities: Samba (GLSA-200705-15), BIND (GLSA-200702-06), MIT
    Kerberos 5 (GLSA-200707-11), Vixie Cron (GLSA-200704-11), shadow
    (GLSA-200606-02), OpenLDAP (CVE-2006-4600), PAM (CVE-2004-0813,
    CVE-2007-1716), GCC (CVE-2006-3619) and GDB (CVE-2006-4146).
  
Impact

    Remote attackers within a guest system could possibly exploit these
    vulnerabilities to execute code on the host system with elevated
    privileges or to cause a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2004-0813
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3619
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4146
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4600
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0061
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0062
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0063
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1716
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4496
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4497
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5617
    http://www.gentoo.org/security/en/glsa/glsa-200606-02.xml
    http://www.gentoo.org/security/en/glsa/glsa-200702-06.xml
    http://www.gentoo.org/security/en/glsa/glsa-200704-11.xml
    http://www.gentoo.org/security/en/glsa/glsa-200705-15.xml
    http://www.gentoo.org/security/en/glsa/glsa-200707-11.xml
    http://lists.vmware.com/pipermail/security-announce/2007/000001.html


Solution: 
    All VMware Workstation users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emulation/vmware-workstation-5.5.5.56455"
    All VMware Player users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emulation/vmware-player-1.0.5.56455"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-23] VMware Workstation and Player: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'VMware Workstation and Player: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-emulation/vmware-player", unaffected: make_list("rge 1.0.5.56455", "ge 2.0.1.55017"), vulnerable: make_list("lt 2.0.1.55017")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "app-emulation/vmware-workstation", unaffected: make_list("rge 5.5.5.56455", "ge 6.0.1.55017"), vulnerable: make_list("lt 6.0.1.55017")
)) { security_warning(0); exit(0); }
