# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-31.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28320);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-31");
 script_cve_id("CVE-2007-5846");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-31
(Net-SNMP: Denial of Service)


    The SNMP agent (snmpd) does not properly handle GETBULK requests with
    an overly large "max-repetitions" field.
  
Impact

    A remote unauthenticated attacker could send a specially crafted SNMP
    request to the vulnerable application, possibly resulting in a high CPU
    and memory consumption.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5846


Solution: 
    All Net-SNMP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-analyzer/net-snmp-5.4.1-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-31] Net-SNMP: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Net-SNMP: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-analyzer/net-snmp", unaffected: make_list("ge 5.4.1-r1"), vulnerable: make_list("lt 5.4.1-r1")
)) { security_warning(0); exit(0); }
