# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-33.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28322);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-33");
 script_cve_id("CVE-2007-5794");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-33
(nss_ldap: Information disclosure)


    Josh Burley reported that nss_ldap does not properly handle the LDAP
    connections due to a race condition that can be triggered by
    multi-threaded applications using nss_ldap, which might lead to
    requested data being returned to a wrong process.
  
Impact

    Remote attackers could exploit this race condition by sending queries
    to a vulnerable server using nss_ldap, possibly leading to theft of
    user credentials or information disclosure (e.g. Dovecot returning
    wrong mailbox contents).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5794


Solution: 
    All nss_ldap users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=sys-auth/nss_ldap-258"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-33] nss_ldap: Information disclosure");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'nss_ldap: Information disclosure');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-auth/nss_ldap", unaffected: make_list("ge 258"), vulnerable: make_list("lt 258")
)) { security_warning(0); exit(0); }
