# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29293);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-06");
 script_cve_id("CVE-2007-4992", "CVE-2007-5246");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-06
(Firebird: Multiple buffer overflows)


    Adriano Lima and Ramon de Carvalho Valle reported that functions
    isc_attach_database() and isc_create_database() do not perform proper
    boundary checking when processing their input.
  
Impact

    A remote attacker could send specially crafted requests to the Firebird
    server on TCP port 3050, possibly resulting in the execution of
    arbitrary code with the privileges of the user running Firebird
    (usually firebird).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4992
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5246


Solution: 
    All Firebird users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-db/firebird-2.0.3.12981.0-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-06] Firebird: Multiple buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Firebird: Multiple buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/firebird", unaffected: make_list("ge 2.0.3.12981.0-r2"), vulnerable: make_list("lt 2.0.3.12981.0-r2")
)) { security_warning(0); exit(0); }
