# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29294);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-07");
 script_cve_id("CVE-2007-0237");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-07
(Lookup: Insecure temporary file creation)


    Tatsuya Kinoshita reported that the ndeb-binary function does not
    handle temporay files correctly.
  
Impact

    A local attacker could use a symlink attack to overwrite files with the
    privileges of the user running Lookup.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0237


Solution: 
    All Lookup users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emacs/lookup-1.4.1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-07] Lookup: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Lookup: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-emacs/lookup", unaffected: make_list("ge 1.4.1"), vulnerable: make_list("lt 1.4.1")
)) { security_warning(0); exit(0); }
