# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-08.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29295);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-08");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-08
(AMD64 x86 emulation Qt library: Multiple vulnerabilities)


    The Qt versions used by the AMD64 x86 emulation Qt libraries were
    vulnerable to several flaws (GLSA 200708-16, GLSA 200710-28)
  
Impact

    An attacker could trigger one of the vulnerabilities by causing a Qt
    application to parse specially crafted text or Unicode strings, which
    may lead to the execution of arbitrary code with the privileges of the
    user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200708-16.xml
    http://www.gentoo.org/security/en/glsa/glsa-200710-28.xml


Solution: 
    All AMD64 x86 emulation Qt library users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emulation/emul-linux-x86-qtlibs-20071114-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-08] AMD64 x86 emulation Qt library: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'AMD64 x86 emulation Qt library: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-emulation/emul-linux-x86-qtlibs", arch: "amd64", unaffected: make_list("ge 20071114-r2"), vulnerable: make_list("lt 20071114-r2")
)) { security_warning(0); exit(0); }
