# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-13.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29733);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-13");
 script_cve_id("CVE-2007-5497");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-13
(E2fsprogs: Multiple buffer overflows)


    Rafal Wojtczuk (McAfee AVERT Research) discovered multiple integer
    overflows in libext2fs, that are triggered when processing information
    from within the file system, resulting in heap-based buffer overflows.
  
Impact

    An attacker could entice a user to process a specially-crafted ext2 or
    ext3 file system image (with tools linking against libext2fs, e.g.
    fsck, forensic tools or Xen\'s pygrub), possibly resulting in the
    execution of arbitrary code with the privileges of the user running the
    application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5497


Solution: 
    All E2fsprogs users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=sys-fs/e2fsprogs-1.40.3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-13] E2fsprogs: Multiple buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'E2fsprogs: Multiple buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-fs/e2fsprogs", unaffected: make_list("ge 1.40.3"), vulnerable: make_list("lt 1.40.3")
)) { security_warning(0); exit(0); }
