# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-20.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29817);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-20");
 script_cve_id("CVE-2007-6335", "CVE-2007-6336", "CVE-2007-6337");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-20
(ClamAV: Multiple vulnerabilities)


    iDefense reported an integer overflow vulnerability in the cli_scanpe()
    function when parsing Portable Executable (PE) files packed in the MEW
    format, that could be exploited to cause a heap-based buffer overflow
    (CVE-2007-6335). Toeroek Edwin reported an off-by-one error when
    decompressing MS-ZIP compressed CAB files (CVE-2007-6336). An
    unspecified vulnerability related to the bzip2 decompression algorithm
    has also been discovered (CVE-2007-6337).
  
Impact

    A remote attacker could entice a user or automated system to scan a
    specially crafted file, possibly leading to the execution of arbitrary
    code with the privileges of the user running ClamAV (either a system
    user or the "clamav" user if clamd is compromised).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6335
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6336
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6337


Solution: 
    All ClamAV users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-antivirus/clamav-0.91.2-r1"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-20] ClamAV: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'ClamAV: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-antivirus/clamav", unaffected: make_list("ge 0.91.2-r1"), vulnerable: make_list("lt 0.91.2-r1")
)) { security_hole(0); exit(0); }
