# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-22.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29819);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-22");
 script_cve_id("CVE-2007-6520", "CVE-2007-6521", "CVE-2007-6522", "CVE-2007-6524");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-22
(Opera: Multiple vulnerabilities)


    David Bloom reported two vulnerabilities where plug-ins (CVE-2007-6520)
    and Rich text editing (CVE-2007-6522) could be used to allow cross
    domain scripting. Alexander Klink (Cynops GmbH) discovered an issue
    with TLS certificates (CVE-2007-6521). Gynvael Coldwind reported that
    bitmaps might reveal random data from memory (CVE-2007-6524).
  
Impact

    A remote attacker could exploit these vulnerabilites, possibly leading
    to the execution of arbitrary code and cross domain scripting.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6520
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6521
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6522
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6524


Solution: 
    All Opera users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/opera-9.25"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-22] Opera: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Opera: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/opera", unaffected: make_list("ge 9.25"), vulnerable: make_list("lt 9.25")
)) { security_warning(0); exit(0); }
