# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-23.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29820);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-23");
 script_cve_id("CVE-2007-6111", "CVE-2007-6112", "CVE-2007-6113", "CVE-2007-6114", "CVE-2007-6115", "CVE-2007-6116", "CVE-2007-6117", "CVE-2007-6118", "CVE-2007-6119", "CVE-2007-6120", "CVE-2007-6121", "CVE-2007-6438", "CVE-2007-6439", "CVE-2007-6441", "CVE-2007-6450", "CVE-2007-6451");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-23
(Wireshark: Multiple vulnerabilities)


    Multiple buffer overflows and infinite loops were discovered in
    multiple dissector and parser components, including those for MP3 and
    NCP (CVE-2007-6111), PPP (CVE-2007-6112), DNP (CVE-2007-6113), SSL and
    iSeries (OS/400) Communication traces (CVE-2007-6114), ANSI MAP
    (CVE-2007-6115), Firebird/Interbase (CVE-2007-6116), HTTP
    (CVE-2007-6117), MEGACO (CVE-2007-6118), DCP ETSI (CVE-2007-6119),
    Bluetooth SDP (CVE-2007-6120), RPC Portmap (CVE-2007-6121), SMB
    (CVE-2007-6438), IPv6 amd USB (CVE-2007-6439), WiMAX (CVE-2007-6441),
    RPL (CVE-2007-6450), CIP (CVE-2007-6451). The vulnerabilities were
    discovered by Stefan Esser, Beyond Security, Fabiodds, Peter Leeming,
    Steve and ainsley.
  
Impact

    A remote attacker could send specially crafted packets on a network
    being monitored with Wireshark or entice a user to open a specially
    crafted file, possibly resulting in the execution of arbitrary code
    with the privileges of the user running Wireshark (which might be the
    root user), or a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6111
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6112
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6113
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6114
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6115
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6116
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6117
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6118
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6119
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6120
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6121
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6438
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6439
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6441
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6450
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6451


Solution: 
    All Wireshark users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-analyzer/wireshark-0.99.7"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-23] Wireshark: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Wireshark: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-analyzer/wireshark", unaffected: make_list("ge 0.99.7"), vulnerable: make_list("lt 0.99.7")
)) { security_hole(0); exit(0); }
